# configuron

Simple environ based config that reloads itself from `project.clj` when in dev mode.

[![Clojars Project](https://img.shields.io/clojars/v/rocks.clj/configuron.svg)](https://clojars.org/rocks.clj/configuron)

## Usage

### Clojure

1. Add `:mode` keys for each of your profiles in `project.clj`

```clojure
{:profiles {:dev {:env {:mode :dev}}
            :uberjar {:env {:mode :prod}}}}
```

2. Access your config through `rocks.clj.configuron.core/env` instead of `environ.core/env`.

### ClojureScript

You can use your config on client-side as well.
Simply add GET route `/environ` to your project with handler `rocks.clj.configuron.core/config-handler`.
By default your client-side config will be empty.
To add some data you should add paths to `:client-config-keys`.
For example given your profiles look like this.
```
{:profiles {:dev {:env {:mode :dev
                        :debug-info {:tokens {:sentry ""}}
                        :client-config-keys [[:mode]
                                             [:debug-info :tokens]]}}
            :uberjar {:env {:mode :uberjar
                            :client-config-keys [[:mode]]}}}}
```
`/environ` ring handler will return
In dev:
```
{:mode :dev
 :debug-info {:tokens {:sentry ""}}}
```
In prod:
```
{:mode :dev}
```

You can access your config on client side as usual through `rocks.clj.configuron.core/env`
or dynamically by executing http request to `/environ`.

## License

Copyright © 2018 Eduard Knyshov

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
