/*
 * Decompiled with CFR 0.152.
 */
package rockers.veer66;

import java.util.ArrayList;
import java.util.List;
import rockers.veer66.CharPrefixTree;
import rockers.veer66.DagEdge;
import rockers.veer66.DagEdgeBuilder;
import rockers.veer66.Edge;
import rockers.veer66.EdgeBuilder;
import rockers.veer66.EdgeBuildingContext;
import rockers.veer66.EdgeType;
import rockers.veer66.Pointer;

public class DictEdgeBuilder
implements EdgeBuilder,
DagEdgeBuilder {
    CharPrefixTree dix;
    List<Pointer> pointers;
    int pointers_size = 0;
    static final int MAX_SIZE = 255;

    DictEdgeBuilder(CharPrefixTree dix) {
        this.dix = dix;
        this.pointers = new ArrayList<Pointer>(255);
    }

    public void addPointer(EdgeBuildingContext context) {
        Pointer p = new Pointer(0, context.i, 0, false);
        if (this.pointers.size() <= this.pointers_size) {
            this.pointers.add(p);
        } else {
            this.pointers.set(this.pointers_size, p);
        }
        ++this.pointers_size;
    }

    public void updatePointers(EdgeBuildingContext context) {
        int j = 0;
        for (int i = 0; i < this.pointers_size; ++i) {
            if (!this.pointers.get(i).update(this.dix, context.ch)) continue;
            if (j < i) {
                this.pointers.set(j, this.pointers.get(i));
            }
            ++j;
        }
        this.pointers_size = j;
    }

    public Edge genEdge(List<Edge> path) {
        Edge bestEdge = null;
        for (int i = 0; i < this.pointers_size; ++i) {
            Pointer pointer = this.pointers.get(i);
            if (!pointer.isFinal) continue;
            Edge edge = pointer.genEdge(path);
            if (bestEdge == null) {
                bestEdge = edge;
                continue;
            }
            if (!edge.isBetterThan(bestEdge)) continue;
            bestEdge = edge;
        }
        return bestEdge;
    }

    @Override
    public Edge build(EdgeBuildingContext context, List<Edge> path) {
        this.addPointer(context);
        this.updatePointers(context);
        return this.genEdge(path);
    }

    @Override
    public List<DagEdge> buildDagEdges(EdgeBuildingContext context) {
        this.addPointer(context);
        this.updatePointers(context);
        ArrayList<DagEdge> edges = new ArrayList<DagEdge>();
        for (int i = 0; i < this.pointers_size; ++i) {
            Pointer p = this.pointers.get(i);
            if (!p.isFinal) continue;
            edges.add(new DagEdge(p.s, context.i + 1, EdgeType.DICT));
        }
        return edges;
    }
}

