/*
 * Decompiled with CFR 0.152.
 */
package rockers.veer66;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import rockers.veer66.CharPrefixTree;
import rockers.veer66.DagEdge;
import rockers.veer66.DagEdgeBuilder;
import rockers.veer66.DictEdgeBuilder;
import rockers.veer66.Edge;
import rockers.veer66.EdgeBuilder;
import rockers.veer66.EdgeBuildingContext;
import rockers.veer66.EdgeType;
import rockers.veer66.PatEdgeBuilder;
import rockers.veer66.UnkEdgeBuilder;

public class Dag {
    public List<List<DagEdge>> dag;

    public static EdgeBuildingContext createDefaultContext(char[] text) {
        EdgeBuildingContext context = new EdgeBuildingContext();
        context.text = text;
        context.leftBoundary = 0;
        context.bestEdge = null;
        return context;
    }

    public static List<EdgeBuilder> createDefaultBuilders(CharPrefixTree dix) {
        return Arrays.asList(new DictEdgeBuilder(dix), PatEdgeBuilder.createLatinEdgeBuilder(), PatEdgeBuilder.createPuncEdgeBuilder(), new UnkEdgeBuilder());
    }

    public static List<DagEdgeBuilder> createDefaultDagBuilders(CharPrefixTree dix) {
        return Arrays.asList(new DictEdgeBuilder(dix), PatEdgeBuilder.createLatinEdgeBuilder(), PatEdgeBuilder.createPuncEdgeBuilder());
    }

    public static List<Edge> createDefaultPath() {
        ArrayList<Edge> path = new ArrayList<Edge>();
        path.add(new Edge(0, EdgeType.INIT, 0, 0));
        return path;
    }

    public static List<Edge> buildPath(CharPrefixTree dix, char[] text) {
        List<EdgeBuilder> builders = Dag.createDefaultBuilders(dix);
        List<Edge> path = Dag.createDefaultPath();
        EdgeBuildingContext context = Dag.createDefaultContext(text);
        for (int i = 0; i < text.length; ++i) {
            context.ch = text[i];
            context.i = i;
            context.bestEdge = null;
            for (EdgeBuilder builder : builders) {
                Edge edge = builder.build(context, path);
                if (!Edge.isBetterThan(edge, context.bestEdge)) continue;
                context.bestEdge = edge;
            }
            if (context.bestEdge == null) {
                throw new RuntimeException("Best edge can't be null");
            }
            path.add(context.bestEdge);
            if (context.bestEdge.isUnk()) continue;
            context.leftBoundary = i + 1;
        }
        return path;
    }

    Dag(int size) {
        this.dag = new ArrayList<List<DagEdge>>(size + 1);
        IntStream.range(0, size + 1).forEach(i -> this.dag.add(new ArrayList()));
        this.dag.get(0).add(new DagEdge(0, 0, EdgeType.INIT));
    }

    public void build(CharPrefixTree dix, char[] text) {
        List<DagEdgeBuilder> builders = Dag.createDefaultDagBuilders(dix);
        EdgeBuildingContext context = Dag.createDefaultContext(text);
        for (int i = 0; i < text.length; ++i) {
            context.ch = text[i];
            context.i = i;
            context.bestEdge = null;
            for (DagEdgeBuilder builder : builders) {
                for (DagEdge edge : builder.buildDagEdges(context)) {
                    this.dag.get(edge.e).add(edge);
                }
            }
        }
        int leftBoundary = 0;
        for (int i = 1; i <= text.length; ++i) {
            if (this.dag.get(i).size() == 0) {
                this.dag.get(i).add(new DagEdge(leftBoundary, i, EdgeType.UNK));
                continue;
            }
            leftBoundary = i;
        }
    }

    public static Dag buildDag(CharPrefixTree dix, char[] text) {
        Dag dag = new Dag(text.length);
        dag.build(dix, text);
        return dag;
    }
}

