# Snabbdom ClojureScript wrapper

A simple wrapper for the excellent [Snabbdom.js](https://github.com/snabbdom/snabbdom).
modu
## Usage

```clojure
(require '[snabbdom.core :as sd]')

(defn app-ch []
  (let [input-ch (async/chan 1)]
    (async/go-loop [old (.getElementById js/document "app")]
      (when-let [vnode (async/<! input-ch)]
        (recur (sd/patch old vnode))))
    input-ch))

(def ch (app-ch))
(def v1 (sd/vnode 
          [:div 
            [:h1 "OK"]
            nil
            [:p "world"]]))
(async/put! ch v1)

```

In short, just 2 functions:

### patch

 - to patch the document element and incremently the root vnode
 
### vnode

 - hiccup style data structure to make snabbdom's vnode
