;; This file was generated with lein-dalap from
;;
;; src/wireframes/common.clj @ Tue Feb 18 23:19:33 GMT 2014
;;
(ns wireframes.common (:require [clojure.string :as str]))
(defn parse-int ([s] (parse-int s 10)) ([s r] (when-not (empty? s) (js/parseInt s r))))
(defn parse-double [s] (when-not (empty? s) (js/parseFloat s)))
(defn decrement-offset [n] (when-not (nil? n) (dec n)))
(defn parse-string [regex element-converter s] (->> (str/split s regex) (mapv element-converter)))
(def parse-csv (partial parse-string #","))
(defn simple-concat "Useful for when (count xs) is small, cons's the xs onto the front of the ys\n   without the overhead of lazy thunking. Disadvantage is that for large xs\n   stack overflow may occur." [xs ys] (if (seq xs) (cons (first xs) (simple-concat (next xs) ys)) ys))
(defn pad [s n] (-> (apply str s (repeat n \space)) (subs 0 n)))