;; This file was generated with lein-dalap from
;;
;; src/inkspot/converter.clj @ Thu Feb 06 00:49:34 GMT 2014
;;
(ns inkspot.converter (:require [inkspot.color :refer [coerce red green blue]]))
(defn rgb->hsv [color] (let [r (/ (red color) 255.0) g (/ (green color) 255.0) b (/ (blue color) 255.0) v (max r g b) d (- v (min r g b))] (if (zero? d) [0.0 0.0 v] (let [s (/ d v) [dr dg db] (map (fn* [p1__1765#] (/ (- v p1__1765#) d)) [r g b]) h (condp = v r (- db dg) g (- (+ 2.0 dr) db) b (- (+ 4.0 dg) dr)) h (mod (* h 60.0) 360.0)] [h s v]))))
(defn hsv->rgb [[h s v]] (if (zero? s) (coerce [v v v]) (let [h (mod (/ h 60) 6) i (int h) f (if (even? i) (- 1 (- h i)) (- h i)) v (* v 255.0) m (* v (- 1.0 s)) n (* v (- 1.0 (* s f)))] (coerce (condp = i 0 [v n m] 1 [n v m] 2 [m v n] 3 [m n v] 4 [n m v] [v m n])))))
(defn rgb->hsl [color] (let [r (/ (red color) 255.0) g (/ (green color) 255.0) b (/ (blue color) 255.0) min-val (min r g b) max-val (max r g b) l (/ (+ max-val min-val) 2.0)] (if (= min-val max-val) [0.0 0.0 l] (let [d (- max-val min-val) s (if (< l 0.5) (/ d (+ max-val min-val)) (/ d (- 2.0 max-val min-val))) [dr dg db] (map (fn* [p1__1766#] (/ (- max-val p1__1766#) d)) [r g b]) h (condp = max-val r (- db dg) g (- (+ 2.0 dr) db) b (- (+ 4.0 dg) dr)) h (mod (* h 60.0) 360.0)] [h s l]))))
(defn hsl->rgb [[h s l]] (if (zero? s) (coerce [l l l]) (let [n2 (if (< l 0.5) (* l (+ 1.0 s)) (- (+ l s) (* l s))) n1 (- (* 2.0 l) n2) h (/ h 60.0) f (fn [h] (let [h (mod h 6.0)] (cond (< h 1.0) (+ n1 (* (- n2 n1) h)) (< h 3.0) n2 (< h 4.0) (+ n1 (* (- n2 n1) (- 4.0 h))) :else n1))) r (* 255.0 (f (+ h 2))) g (* 255.0 (f h)) b (* 255.0 (f (- h 2)))] (coerce [r g b]))))
(defn rgb->yuv [color] (let [r (/ (red color) 255.0) g (/ (green color) 255.0) b (/ (blue color) 255.0) y (+ (* r 0.299) (* g 0.587) (* b 0.114)) u (+ (* r -0.14713) (* g -0.28886) (* b 0.436)) v (+ (* r 0.615) (* g -0.51499) (* b -0.10001))] [y u v]))
(defn yuv->rgb [[y u v]] (let [r (* (+ y (* v 1.13983)) 255.0) g (* (- y (* u 0.39465) (* v 0.5806)) 255.0) b (* (+ y (* u 2.03211)) 255.0)] (coerce [r g b])))
(defn grayscale [color] (let [[y _ _] (map (partial * 255.0) (rgb->yuv color))] (coerce [y y y])))
(defn complementary [color] (let [[h s l] (rgb->hsl color)] (hsl->rgb [(mod (+ h 180) 360) s l])))