(ns cling.util.project
  (:require [clojure.string :as str]))

(defn project-id []
  (first (str/split (str *ns*) #"\.")))

(defmacro version [key]
  (System/getProperty key))

(defmacro git-hash []
  (require '[clojure.java.shell]
           '[clojure.string])
  (try
    (let [ret (clojure.java.shell/sh "git" "rev-parse" "HEAD")]
      (when (zero? (:exit ret)) (when-let [h (:out ret)] (clojure.string/trim h))))
    (catch Throwable _)))

(defmacro git-timestamp []
  (require '[clojure.java.shell]
           '[clojure.string])
  (try
    (let [ret (clojure.java.shell/sh  "git" "show" "-s" "--format=%ct" "HEAD")]
      (when (zero? (:exit ret))
        (when-let [h (:out ret)]
          (* (Integer/parseInt (clojure.string/trim h)) 1000))))
    (catch Throwable _)))
