(ns cling.parser
  (:require [clojure.tools.cli :as cli]))

;;; TODO: Extend syntax
(defn compile-option-specs [option-specs]
  (#'cli/compile-option-specs option-specs))

(defn parse-opts [args option-specs & options]
  (apply cli/parse-opts args option-specs options))

(defn compile-argument-spec [spec]
  (let [id-desc (take-while #(or (string? %) (nil? %)) spec)
        spec-map (apply hash-map (drop (count id-desc) spec))
        [id desc] id-desc]
    (merge {:parse-fn identity}
           {:id (keyword id) :desc desc}
           spec-map)))

(defn compile-argument-specs [argument-specs]
  (map compile-argument-spec argument-specs)

  ;; TODO: validate
  )

(defn validate-argument-specs [argument-specs]
  )

(defn parse-argument-spec [arg spec]
  {:pre [(fn? (:parse-fn spec))]}
  (try
    (let [val ((:parse-fn spec) arg)
          val (if (:variadic? spec) [val] val)]
      [val nil])
    (catch Throwable e
      [nil (str e)])))

(defn parse-argument-specs [args specs]
  (loop [args   args
         specs  specs
         parsed []
         errors []]
    (cond
      (and (empty? args) (empty? specs))
      {:errors errors
       :arguments (apply merge-with concat parsed)}

      (and (seq args) (empty? specs))
      (recur [] [] parsed (conj errors "Too many arguments"))

      (and (empty? args) (seq specs))
      (if (:optional? (first specs))
        (recur [] [] parsed errors)
        (recur [] [] parsed (conj errors "Too few arguments")))

      :else
      (let [spec      (first specs)
            arg       (first args)
            [val err] (parse-argument-spec arg spec)]
        (recur (rest args)
               (if (:variadic? spec)
                 [(assoc spec :optional? true)]
                 (rest specs))
               (if err parsed (conj parsed {(:id spec) val}))
               (if err (conj errors err) errors))))))

(defn parse-args [args argument-specs]
  (let [compiled-specs (compile-argument-specs argument-specs)]
    ;; (validate-argument-specs argument-specs)
    (parse-argument-specs args compiled-specs)))
