(ns cling.core
  (:require [cling.cmd :as cmd]
            [cling.middleware :as m]))

(def ^:dynamic *exit-process?* false)

(defn exit
  [status]
  (if *exit-process?*
    (do
      (shutdown-agents)
      (System/exit status))
    (println "[DRY RUN] Finished with exit code" status)))

(defn handle-response [res]
  (when (map? res)
    (let [{:keys [body status]} res]
      (when body
        (println body))
      (when status
        (exit status)))))

(defn wrap-responder [handler]
  (fn [env]
    (handle-response (handler env))))

(defn default-handler [env]
  (cmd/fail!))

(defn create-handler [route-spec]
  (-> default-handler
      m/wrap-dispatcher
      m/wrap-error-raiser
      m/wrap-help-fallback
      m/wrap-help-option-handler
      m/wrap-help-command
      m/wrap-subcommands-info
      m/wrap-arguments-parser
      m/wrap-options-parser
      (m/wrap-router route-spec)
      m/wrap-exception-formatter
      wrap-responder
      m/wrap-base))
