(ns cling.context)

(defn get-context [spec]
  (:cling/cli (meta spec)))

(defn with-context [spec m]
  (with-meta spec {:cling/cli m}))

(defn merge-context [a b]
  (let [m {:option-specs concat}]
    (reduce (fn [acc [k v]]
              (if (contains? m k)
                (update-in acc [k] (get m k) v)
                (assoc acc k v))) a b)))
