(ns leiningen.new.ring-piggieback
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "ring-piggieback"))

(defn ring-piggieback
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data 
             ["test/{{sanitized}}/core_test.clj" (render "core_test.clj" data)]
             ["project.clj" (render "project.clj" data)]
             ["index.html"  (render "index.html")]
             ["favicon.ico" (render "favicon.ico")]
             ["piggieback_browser.cljs" (render "piggieback_browser.cljs")]
             ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
             )))
