(ns {{name}}.server
    (:require  [cider.nrepl :refer [cider-nrepl-handler]]
               [clojure.tools.nrepl.server :as nrepl]
               [clojure.java.io :as io]
               [clojure.tools.logging :as log]
               [ring.middleware.cors :refer :all]
               [ring.middleware.defaults :refer :all]
               [ring.middleware.edn :refer :all]
               [ring.middleware.json :refer [wrap-json-response wrap-json-body]]
               [ring.middleware.session :as session]
               [ring.middleware.params :as params]
               [ring.middleware.keyword-params :as keyword-params]
               [ring.middleware.nested-params :as nested-params]
               [compojure.handler :refer [site] :as handler]
               [prone.debug :refer [debug]]
               [org.httpkit.server :as httpkit]
               [environ.core :refer [env]]
               [{{name}}.config :as conf]
               [{{name}}.data :as data]
               [{{name}}.router :as router])
    (:gen-class))

(def app
  (->
   (handler/site router/routes)
   (wrap-json-body)
   (wrap-json-response)
   (wrap-edn-params)
   (wrap-defaults api-defaults)
   ;; WARNING: Change origin domain to your prod domain
   (wrap-cors
    :access-control-allow-origin #".+"
    :access-control-allow-methods [:get :post :put :delete :head]
    :access-control-allow-headers ["Content-Type" "X-Requested-With"])))

(defn- start-nrepl [port]
  (log/info (str "Starting nREPL server at " port))
  (nrepl/start-server :port port :handler cider-nrepl-handler))

(defn- start-server [port]
  (log/info (str  "Starting server at " port))
  (httpkit/run-server app {:port port}))

(defn init []
  (conf/load-env)
  (data/init (conf/db-url))
  (start-nrepl (conf/nrepl-port)))

(defn -main [& args]
  (init)
  (start-server (conf/server-port))
  (log/info "Server started and listening at port..." (conf/server-port)))
