(ns rill.wheel.message-map
  (:require [rill.wheel.macro-utils :refer [keyword-in-current-ns]]
            [clojure.spec.alpha :as s]))

;;;; required interfaces of messages
;;;;
;;;; commands:
;;;; fetch-aggregate* (repo, msg) -> aggregate
;;;; apply-command* (aggregate, msg) -> aggregate or rejection
;;;;
;;;; events:
;;;; apply-event* (aggregate, msg) -> aggregate
;;;;
;;;; for speccing:
;;;; defmethod message-spec
;;;; where to apply that spec? - anywhere it's useful I guess



(s/def ::keys-list (s/and (s/coll-of qualified-keyword?)
                          sequential?))

(s/def ::req ::keys-list)
(s/def ::opt ::keys-list)
(s/def ::opt-un ::keys-list)
(s/def ::req-un ::keys-list)


(s/fdef defmessage-map
        :args (s/cat :type symbol?
                     :keys-spec (s/keys :opt-un [::req ::req-un ::opt-un ::opt])))

(defn- combine-arglists
  [required optional]
  (if (seq optional)
    (conj (vec required)
          '&
          (vec optional))
    (vec required)))

(defmacro defmessage-map
  [type keys-spec]
  (let [tag                    (keyword-in-current-ns type)
        map-constructor        (symbol (str "map->" (name type)))
        positional-constructor (symbol (str "->" (name type)))
        req-keys               (vec (concat (:req-un keys-spec) (:req keys-spec)))
        opt-keys               (vec (concat (:opt-un keys-spec) (:opt keys-spec)))]
    `(do
       (s/def tag
         (s/and (s/keys ~keys-spec)
                #(= ~tag (:rill.message/type %))))
       (defn ~map-constructor
         {:arglists '([m])}
         [m#]
         (assoc m# :rill.message/type ~tag))
       ~(let [req-args (vec (repeatedly (count req-keys) #(gensym "req-arg")))
              opt-args (vec (repeatedly (count opt-keys) #(gensym "opt-arg")))]
          `(defn ~positional-constructor
             {:arglists '(~(combine-arglists req-keys opt-keys))}
             ~(combine-arglists req-args opt-args)
             ~(assoc (zipmap (concat req-keys opt-keys)
                             (concat req-args opt-args))
                     :rill.message/type tag))))))
