/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.fusesource.stomp.jms.StompJmsConnection;
import org.fusesource.stomp.jms.StompJmsExceptionSupport;
import org.fusesource.stomp.jms.StompJmsPrefetch;
import org.fusesource.stomp.jms.StompJmsQueueConnection;
import org.fusesource.stomp.jms.StompJmsTopicConnection;
import org.fusesource.stomp.jms.jndi.JNDIStorable;
import org.fusesource.stomp.jms.util.PropertyUtil;

public class StompJmsConnectionFactory
extends JNDIStorable
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private URI brokerURI;
    private URI localURI;
    private String username;
    private String password;
    private SSLContext sslContext;
    boolean forceAsyncSend;
    boolean omitHost;
    String queuePrefix = "/queue/";
    String topicPrefix = "/topic/";
    String tempQueuePrefix = "/temp-queue/";
    String tempTopicPrefix = "/temp-topic/";
    long disconnectTimeout = 10000L;
    StompJmsPrefetch prefetch = new StompJmsPrefetch();

    public void setProperties(Properties props) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        this.setProperties(map);
    }

    @Override
    public void setProperties(Map<String, String> map) {
        this.buildFromProperties(map);
    }

    @Override
    protected void buildFromProperties(Map<String, String> map) {
        PropertyUtil.setProperties(this, map);
    }

    @Override
    protected void populateProperties(Map<String, String> map) {
        try {
            Map<String, String> result = PropertyUtil.getProperties(this);
            map.putAll(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(this.getUsername(), this.getPassword());
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        try {
            StompJmsTopicConnection result = new StompJmsTopicConnection(this.brokerURI, this.localURI, userName, password, this.sslContext);
            PropertyUtil.setProperties(result, PropertyUtil.getProperties(this));
            return result;
        }
        catch (Exception e) {
            throw StompJmsExceptionSupport.create(e);
        }
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(this.getUsername(), this.getPassword());
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        try {
            StompJmsConnection result = new StompJmsConnection(this.brokerURI, this.localURI, userName, password, this.sslContext);
            PropertyUtil.setProperties(result, PropertyUtil.getProperties(this));
            return result;
        }
        catch (Exception e) {
            throw StompJmsExceptionSupport.create(e);
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(this.getUsername(), this.getPassword());
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        try {
            StompJmsQueueConnection result = new StompJmsQueueConnection(this.brokerURI, this.localURI, userName, password, this.sslContext);
            PropertyUtil.setProperties(result, PropertyUtil.getProperties(this));
            return result;
        }
        catch (Exception e) {
            throw StompJmsExceptionSupport.create(e);
        }
    }

    public String getBrokerURI() {
        return this.brokerURI != null ? this.brokerURI.toString() : "";
    }

    public void setBrokerURI(String brokerURI) {
        if (brokerURI == null) {
            throw new IllegalArgumentException("brokerURI cannot be null");
        }
        this.brokerURI = this.createURI(brokerURI);
    }

    public String getLocalURI() {
        return this.localURI != null ? this.localURI.toString() : "";
    }

    public void setLocalURI(String localURI) {
        this.localURI = this.createURI(localURI);
    }

    private URI createURI(String name) {
        if (name != null && !name.trim().isEmpty()) {
            try {
                return new URI(name);
            }
            catch (URISyntaxException e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Invalid broker URI: " + name).initCause(e);
            }
        }
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isForceAsyncSend() {
        return this.forceAsyncSend;
    }

    public void setForceAsyncSend(boolean forceAsyncSend) {
        this.forceAsyncSend = forceAsyncSend;
    }

    public boolean isOmitHost() {
        return this.omitHost;
    }

    public void setOmitHost(boolean omitHost) {
        this.omitHost = omitHost;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    public String getTempQueuePrefix() {
        return this.tempQueuePrefix;
    }

    public void setTempQueuePrefix(String tempQueuePrefix) {
        this.tempQueuePrefix = tempQueuePrefix;
    }

    public String getTempTopicPrefix() {
        return this.tempTopicPrefix;
    }

    public void setTempTopicPrefix(String tempTopicPrefix) {
        this.tempTopicPrefix = tempTopicPrefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public long getDisconnectTimeout() {
        return this.disconnectTimeout;
    }

    public void setDisconnectTimeout(long disconnectTimeout) {
        this.disconnectTimeout = disconnectTimeout;
    }

    public StompJmsPrefetch getPrefetch() {
        return this.prefetch;
    }

    public void setPrefetch(StompJmsPrefetch prefetch) {
        this.prefetch = prefetch;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public JMSContext createContext() {
        throw new UnsupportedOperationException("Please contact the maintainer to request implementation of this method.");
    }

    public JMSContext createContext(int i) {
        throw new UnsupportedOperationException("Please contact the maintainer to request implementation of this method.");
    }

    public JMSContext createContext(String s1, String s2) {
        throw new UnsupportedOperationException("Please contact the maintainer to request implementation of this method.");
    }

    public JMSContext createContext(String s1, String s2, int i) {
        throw new UnsupportedOperationException("Please contact the maintainer to request implementation of this method.");
    }
}

