/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms;

import jakarta.jms.JMSException;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import java.util.Map;
import java.util.UUID;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.stomp.client.Constants;
import org.fusesource.stomp.codec.StompFrame;
import org.fusesource.stomp.jms.StompJmsConnection;
import org.fusesource.stomp.jms.StompJmsMessageConsumer;
import org.fusesource.stomp.jms.StompJmsPrefetch;
import org.fusesource.stomp.jms.StompJmsSession;
import org.fusesource.stomp.jms.StompJmsTempQueue;
import org.fusesource.stomp.jms.StompJmsTempTopic;
import org.fusesource.stomp.jms.StompServerAdaptor;

public class ApolloServerAdaptor
extends StompServerAdaptor {
    static final StompJmsPrefetch DEFAULT_PREFETCH = new StompJmsPrefetch();

    @Override
    public boolean matchesServerAndVersion(String server) {
        return server != null && server.startsWith("apache-apollo/");
    }

    @Override
    public StompJmsTempQueue isTempQueue(StompJmsConnection connection, String value) {
        if (value.startsWith(connection.queuePrefix + "temp.")) {
            return new StompJmsTempQueue(connection.queuePrefix, value.substring(connection.queuePrefix.length()));
        }
        return super.isTempQueue(connection, value);
    }

    @Override
    public StompJmsTempTopic isTempTopic(StompJmsConnection connection, String value) throws JMSException {
        if (value.startsWith(connection.topicPrefix + "temp.")) {
            return new StompJmsTempTopic(connection.topicPrefix, value.substring(connection.topicPrefix.length()));
        }
        return super.isTempTopic(connection, value);
    }

    @Override
    public StompFrame createCreditFrame(StompJmsMessageConsumer consumer, StompFrame messageFrame) {
        Buffer content = messageFrame.content();
        Object credit = "1";
        if (content != null) {
            credit = (String)credit + "," + content.length();
        }
        StompFrame frame = new StompFrame();
        frame.action(Constants.ACK);
        frame.headerMap().put(Constants.SUBSCRIPTION, consumer.id);
        frame.headerMap().put(Constants.CREDIT, AsciiBuffer.ascii((String)credit));
        return frame;
    }

    private String createApolloTempDestName(StompJmsSession session) throws JMSException {
        String host = session.getChannel().getConnectedHostId();
        if (host == null) {
            host = session.connection.brokerURI.getHost();
        }
        String sessionId = session.getChannel().getConnectedSessionId();
        return "temp." + host + "." + sessionId + "." + UUID.randomUUID().toString();
    }

    @Override
    public TemporaryQueue createTemporaryQueue(StompJmsSession session) throws JMSException {
        return new StompJmsTempQueue(session.connection.queuePrefix, this.createApolloTempDestName(session));
    }

    @Override
    public TemporaryTopic createTemporaryTopic(StompJmsSession session) throws JMSException {
        return new StompJmsTempTopic(session.connection.topicPrefix, this.createApolloTempDestName(session));
    }

    @Override
    public void addSubscribeHeaders(Map<AsciiBuffer, AsciiBuffer> headerMap, boolean persistent, boolean browser, boolean noLocal, StompJmsPrefetch prefetch) throws JMSException {
        if (noLocal) {
            throw new JMSException("Server does not support 'no local' semantics over STOMP");
        }
        if (persistent) {
            headerMap.put(Constants.PERSISTENT, Constants.TRUE);
        }
        if (browser) {
            headerMap.put(Constants.BROWSER, Constants.TRUE);
        }
        if (!prefetch.equals(DEFAULT_PREFETCH)) {
            headerMap.put(Constants.CREDIT, AsciiBuffer.ascii((String)(prefetch.getMaxMessages() + "," + prefetch.getMaxBytes())));
        }
    }

    @Override
    public StompFrame createUnsubscribeFrame(AsciiBuffer consumerId, boolean persistent) throws JMSException {
        StompFrame frame = new StompFrame();
        frame.action(Constants.UNSUBSCRIBE);
        frame.headerMap().put(Constants.ID, consumerId);
        if (persistent) {
            frame.headerMap().put(Constants.PERSISTENT, Constants.TRUE);
        }
        return frame;
    }
}

