/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.client;

import java.util.ArrayList;
import java.util.LinkedList;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.stomp.client.Callback;
import org.fusesource.stomp.client.CallbackConnection;
import org.fusesource.stomp.client.Future;
import org.fusesource.stomp.client.Promise;
import org.fusesource.stomp.codec.StompFrame;

public class FutureConnection {
    private final CallbackConnection connection;
    private LinkedList<Promise<StompFrame>> receiveFutures = new LinkedList();
    private LinkedList<StompFrame> receivedFrames = new LinkedList();

    FutureConnection(CallbackConnection connection) {
        this.connection = connection;
        this.connection.receive(new Callback<StompFrame>(){

            @Override
            public void onFailure(Throwable value) {
                FutureConnection.this.getDispatchQueue().assertExecuting();
                ArrayList<Promise<StompFrame>> tmp = new ArrayList<Promise<StompFrame>>(FutureConnection.this.receiveFutures);
                FutureConnection.this.receiveFutures.clear();
                for (Promise<StompFrame> future : tmp) {
                    future.onFailure(value);
                }
            }

            @Override
            public void onSuccess(StompFrame value) {
                FutureConnection.this.getDispatchQueue().assertExecuting();
                if (FutureConnection.this.receiveFutures.isEmpty()) {
                    FutureConnection.this.receivedFrames.add(value);
                } else {
                    FutureConnection.this.receiveFutures.removeFirst().onSuccess(value);
                }
            }
        });
        this.connection.resume();
    }

    public StompFrame connectedFrame() {
        return this.connection.connectedFrame();
    }

    private DispatchQueue getDispatchQueue() {
        return this.connection.getDispatchQueue();
    }

    public Future<Void> close() {
        final Promise<Void> future = new Promise<Void>();
        this.connection.close(new Runnable(){

            @Override
            public void run() {
                future.onSuccess(null);
            }
        });
        return future;
    }

    public AsciiBuffer nextId() {
        return this.connection.nextId();
    }

    public AsciiBuffer nextId(String prefix) {
        return this.connection.nextId(prefix);
    }

    public Future<StompFrame> request(final StompFrame frame) {
        final Promise<StompFrame> future = new Promise<StompFrame>();
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.connection.request(frame, future);
            }
        });
        return future;
    }

    public Future<Void> send(final StompFrame frame) {
        final Promise<Void> future = new Promise<Void>();
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.connection.send(frame, future);
            }
        });
        return future;
    }

    public Future<StompFrame> receive() {
        final Promise<StompFrame> future = new Promise<StompFrame>();
        this.getDispatchQueue().execute(new Task(){

            public void run() {
                if (FutureConnection.this.connection.getFailure() != null) {
                    future.onFailure(FutureConnection.this.connection.getFailure());
                } else if (FutureConnection.this.receivedFrames.isEmpty()) {
                    FutureConnection.this.receiveFutures.add(future);
                } else {
                    future.onSuccess(FutureConnection.this.receivedFrames.removeFirst());
                }
            }
        });
        return future;
    }

    public void resume() {
        this.connection.resume();
    }

    public void suspend() {
        this.connection.suspend();
    }
}

