(ns fsm.spec
  (:require [clojure.spec.alpha :as s]))

(def state-id? keyword?)

(s/def ::input any?)

(s/def ::start-at state-id?)

(s/def ::next state-id?)

(s/def ::end #{true})

(s/def ::chosen-state state-id?)

(s/def ::choices (s/coll-of state-id?))

(s/def ::type #{:task :choice})

(defmulti state-type ::type)

(defmethod state-type :task [_]
  (s/and (s/keys :req [::type] :opt [::next ::end])
         #(-> (select-keys % [::next ::end])
              keys
              count
              (= 1))))

(defmethod state-type :choice [_]
  (s/keys :req [::type ::choices]))

(s/def ::state (s/multi-spec state-type ::type))

(s/def ::states (s/map-of state-id? ::state))

(s/def ::fsm (s/keys :req [::start-at ::states]))

(s/def ::context (s/map-of keyword? any?))
