(ns fsm.logic
  (:require [clojure.spec.alpha :as s]
            [fsm.spec :as fsm]))

(defn state-type [fsm state-id _]
  (when state-id
    (-> fsm ::fsm/states state-id ::fsm/type)))

(defmulti state-after state-type)

(defmethod state-after nil [fsm _ _]
  (-> fsm ::fsm/start-at))

(defmethod state-after :task [fsm state-id _]
  (-> fsm ::fsm/states state-id ::fsm/next))

(defmethod state-after :choice [fsm state-id input]
  (->> fsm ::fsm/states state-id ::fsm/choices (some #(when (= % (::fsm/chosen-state input)) %))))

(s/fdef
  state-after
  :args (s/and (s/cat :fsm ::fsm/fsm :state-id (s/nilable fsm/state-id?) :input any?)
               #(or
                  (nil? (:state-id %))
                  (and
                    (get (-> % :fsm ::fsm/states) (:state-id %))
                    (if (= :choice (state-type (:fsm %) (:state-id %) (:input %)))
                      (->> (get (-> % :fsm ::fsm/states) (:state-id %)) ::fsm/choices (some (fn [x] (= (-> % :input ::fsm/chosen-state) x))))
                      true))))
  :ret fsm/state-id?)

(defn state-output [fsm context state-id input]
  (-> context
      state-id
      (apply [input])))

(s/fdef
  state-output
  :args (s/and (s/cat :fsm ::fsm/fsm :context ::fsm/context :state-id fsm/state-id? :input ::fsm/input)
               #(get (-> % :fsm ::fsm/states) (:state-id %))
               #(get (-> % :context) (:state-id %)))
  :ret ::fsm/input)

(defn end-state? [fsm state-id]
  (when state-id
    (-> fsm ::fsm/states state-id ::fsm/end)))

(s/fdef
  end-state?
  :args (s/and (s/cat :fsm ::fsm/fsm :state-id (s/nilable fsm/state-id?))
               #(or
                  (nil? (:state-id %))
                  (get (-> % :fsm ::fsm/states) (:state-id %))))
  :ret boolean?)