(ns fsm.execution
  (:require [fsm.logic :refer [state-after state-output end-state?]]
            [fsm.spec :as fsm]
            [clojure.spec.alpha :as s]
            [clojure.spec.gen.alpha :as gen]))

(defprotocol Execution
  (output [this])
  (state [this])
  (finished? [this])
  (next-step [this]))

(defrecord MapExecution [fsm context state output]
  Execution
  (output [_] output)
  (state [_] state)
  (finished? [_] (end-state? fsm state))
  (next-step [this]
    (let [next-state (state-after fsm state  output)
          next-output (state-output fsm context next-state output)]
      (-> this
          (assoc :state next-state)
          (assoc :output next-output)))))

(defn initial-execution [fsm context input]
  (->MapExecution fsm context nil input))

(s/def ::execution (s/with-gen (partial satisfies? Execution)
                               #(gen/fmap (fn [[fsm context input]] (initial-execution fsm context input))
                                          (gen/tuple (s/gen ::fsm/fsm)
                                                     (s/gen ::fsm/context)
                                                     (s/gen ::fsm/input)))))
