(ns fsm.core
  (:require [clojure.spec.alpha :as s]
            [fsm.execution :refer [initial-execution next-step state finished?] :as execution]
            [fsm.spec :as fsm]))

(defn step [execution]
  (next-step execution))

(s/fdef
  step
  :args (s/cat :execution ::execution/execution)
  :ret ::execution/execution
  :fn #(not= (:ret %) (-> % :args :execution)))

(defn execute [fsm context input]
  (loop [execution (initial-execution fsm context input)]
    (if (finished? execution)
      execution
      (recur (next-step execution)))))

(s/fdef
  execute
  :args (s/cat :fsm ::fsm/fsm :context ::fsm/context :input ::fsm/input)
  :ret ::execution/execution
  :fn #(finished? (:ret %)))
