(ns testus.init
  (:require [reverie.migration :as migration])
  (:use [korma.db :only [defdb postgres]]
        [reverie.server :only [load-views-ns]]))


(defdb testus-db (postgres
                    {:db "dev-reverie"
                     :user "reveriecms"
                     :password "reveriecms"}))
(def lobos-db {:classname "org.postgresql.Driver"
               :subprotocol "postgresql"
               :subname "//localhost:5432/dev-reverie"
               :user "reveriecms"
               :password "reveriecms"})

(defn init []
  (migration/open-global-when-necessary lobos-db)
  (migration/migrate)
  (migration/migrate 'testus.objects.migrations)
  
  (load-views-ns 'testus.templates)
  (load-views-ns 'testus.objects))
