(ns testus.core
  (:gen-class)
  (:require [reverie.server :as server]
            [testus.init :as init])
  (:use [testus.command :only [run-command]]))


(defn -main [& args]
  (if (= :command (read-string (first args)))
    (run-command (map read-string (rest args)))
    (let [settings (merge {:port 8080}
                          (into {}
                                (map (fn [[a b]] {a b})
                                     (partition 2 (map read-string args)))))]
      (init/init)
      (server/start settings))))
