(ns reverie.batteries.objects.migrations
  (:refer-clojure :exclude [alter defonce drop bigint boolean char double float time])
  (:use (lobos [migration :only [defmigration]] core schema)))


(defmigration init-batteries-object-text
  (up [] (create (table :batteries_object_text
                        (integer :id :primary-key :auto-inc :not-null)
                        (text :text :not-null (default ""))
                        (integer :object_id [:refer :object :id] :not-null))))
  (down [] (drop (table :batteries_object_text))))



(defmigration init-batteries-object-raw
  (up [] (create (table :batteries_object_raw
                        (integer :id :primary-key :auto-inc :not-null)
                        (text :text :not-null (default ""))
                        (integer :object_id [:refer :object :id] :not-null))))
  (down [] (drop (table :batteries_object_raw))))


(defmigration init-object-jumbatron
  (up [] (create (table :batteries_object_jumbatron
                        (integer :id :primary-key :auto-inc :not-null)
                        (varchar :when 255 :not-null (default ""))
                        (varchar :title 255 :not-null (default ""))
                        (varchar :image 255 :not-null (default ""))
                        (varchar :url 255 :not-null (default ""))
                        (text :text :not-null (default ""))
                        (integer :object_id [:refer :object :id] :not-null))))
  (down [] (drop (table :batteries_object_jumbatron))))
