(ns reverie.batteries.objects.jumbatron
  (:require [clojure.string :as s])
  (:use [reverie.core :only [defobject]]))

(defobject jumbatron {:table :batteries_object_jumbatron
                      :area/use-render-fn? false
                      :attributes-order [:title :when :image :url :text]
                      :attributes {:text {:initial ""
                                          :input :richtext
                                          :name "Text"}
                                   :when {:initial ""
                                          :input :text
                                          :name "When"}
                                   :image {:initial ""
                                           :input :image
                                           :name "Image"}
                                   :url {:initial ""
                                         :input :url
                                         :name "URL"}
                                   :title {:initial ""
                                           :input :text
                                           :name "Title"}}}
  [:any
   [:div.jumbatron
    [:h2 title]
    [:a.image {:href url}
     [:img {:src image}]]
    (if-not (s/blank? when)
      [:span.when when])
    text
    [:a {:href url} "Read more"]]])
