(ns leiningen.new.restql-server-plugin
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "restql-server-plugin"))

(defn restql-server-plugin
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["project.clj" (render "project.clj" data)]
["src/{{sanitized}}/core.clj" (render "src/restql_plugin_teste/core.clj" data)]
["test/{{sanitized}}/core_test.clj" (render "test/restql_plugin_teste/core_test.clj" data)]
["src/{{sanitized}}/restQL-plugin.json" (render "src/restql_plugin_teste/restQL-plugin.json")]
)))