(ns {{ns-name}}.core
  (:gen-class))

(defn check []
  "Checking that the hook was installed")

(defn before-query-hook [{:keys [query query-params]}]
  (println "THIS SHOULD RUN BEFORE A QUERY EXECUTES"))

(defn after-query-hook [{:keys [query result]}]
  (println "THIS SHOULD RUN AFTER A QUERY EXECUTES"))

(defn before-request-hook [{:keys [resource timeout url query-params headers]}]
  (println "THIS SHOULD RUN AFTER A REQUEST EXECUTES"))

(defn after-request-hook [{:keys [status headers url timeout params response-time]}]
  (println "THIS SHOULD RUN AFTER A REQUEST EXECUTES"))

(defn add-hooks []
  {:before-query [before-query-hook]
   :after-query [after-query-hook]
   :before-request [before-request-hook]
   :after-request [after-request-hook]})
