(ns leiningen.new.restful-app
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "restful-app"))

(defn restful-app
  "Transport and parse content for files"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info (format "Generating a new RESTful Application project - %s." (:sanitized data)))
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["src/{{sanitized}}/server.clj" (render "src/server.clj" data)]
             ["src/{{sanitized}}/default.clj" (render "src/default.clj" data)])))
