-- 一些复杂查询的函数定义脚本
-- 自动生成函数的sql脚本编写约定如下(请参见https://www.hugsql.org/#start-sql理解)：
-- 定义函数的名称 :name or :name- (私有函数）
-- 编写函数的说明文档 :doc
-- 确定sql语句的执行方式即命令类型， 包含查询(:? or :query)、执行(:! or :execute)、插入并返回主键(:insert or :i) 三种
-- 返回结果的类型， 包含一行记录(:one or :1)、多行(:many or :*)、影响的行数(:affected or :n)、原始输出(:raw, 此为不配置此项时的缺省值)
-- 替换参数，包括:
------Values: where id = :id
------Value lists: where id in (:v*:ids)
------Tuple: insert into users (id, name) values :t:vals
------Tuple lists (for multi-insert): values :tuple*:my-records
------SQL identifiers: from :i:table-name
------SQL identifier lists: select :i*:column-names
------SQL keywords: :sql:my-query
------Oracle 专属Tuple, 可以根据需要添加id字段以及SEQ_TABLE_NAME.NEXTVAL： insert into users (id, name) values :ot:vals
------Like 值： and name like :l:name , 会在值两边加上 "%"
------LeftLike 值： and name like :ll:name, 会在值右边加 "%"
------RightLike 值： and name like :rl:name, 会在值左边加 "%"

-- :name list-users :? :*
-- :doc 获取所有的用户信息
select * from users

-- 当对where部分的条件希望根据条件是否为空来确定条件是否自动保留时，推荐如下进行配置. 支持子查询,join字句，层次查询，函数等
-- 注意如下示例函数中仅当params中没有:admin存在时才自动丢弃"admin = :admin", {:admin nil} 和 {:admin false}不会丢弃
-- :name get-users-by-some-not-null-fields :? :*
-- :doc 根据非空字段的信息获取用户信息
select * from users
/*~
(where params "admin = :admin and name like :l:name")
~*/
