(ns {{name}}.middleware
  (:require [ring.middleware.cors :as cors]
            [org.tovictory.utils.framework.config :refer [env]]))

(defn- wrap-cors [handler]
  (cors/wrap-cors
   handler
   :access-control-allow-origin (->> env :rest-api :access-control-allow-origin (map re-pattern))
   :access-control-allow-credentials "true"
   :access-control-allow-methods [:get :put :post :delete]))

(defn wrap-base [handler]
  (-> handler wrap-cors))
