(ns {{name}}.handler
  (:require
   [clojure.tools.logging :as log]
   [mount.core :as mount]
   [compojure.api.sweet :refer :all]
   [ring.util.http-response :refer :all]
   [compojure.route :as route]
   [{{name}}.middleware :refer :all]
   [{{name}}.routes.demo :refer :all]))

(defn init [] (doseq [component (:started (mount/start))]
                (log/info component "started")))

(defn destroy [] (doseq [component (:stopped (mount/stop))]
                   (log/info component "stopped")))

(def app
  (api
   {:swagger
    {:ui "/"
     :spec "/rest-example"
     :data {:info {:title "api示例"
                   :description "rest接口示例程序"}
            :tags [{:name "demo" :description "示例服务"}]}}}

   (context "/{{name}}" []
     :middleware [wrap-base]

     demo)

   (undocumented
    (route/not-found (ok {:error "services not found"})))))