
(ns respo-value.main
  (:require [hsl.core :refer [hsl]]
            [respo-value.schema :as schema]
            [respo.cursor :refer [mutate]]
            [respo.core :refer [render! clear-cache! realize-ssr!]]
            [respo-value.comp.container :refer [comp-container]]))

(defonce store-ref (atom schema/store))

(defn updater [store op op-data] store)

(defn dispatch! [op op-data]
  (let [next-store (if (= op :states)
                     (update @store-ref :states (mutate op-data))
                     (updater @store-ref op op-data))]
    (reset! store-ref next-store)))

(def mount-target (.querySelector js/document ".app"))

(defn render-app! [renderer] (render! mount-target (comp-container @store-ref) dispatch!))

(defn reload! [] (clear-cache!) (render-app! render!) (println "Code updated."))

(def ssr? (some? (js/document.querySelector "meta.respo-ssr")))

(defn main! []
  (if ssr? (render-app! realize-ssr!))
  (render-app! render!)
  (add-watch store-ref :changes (fn [] (render-app! render!))))

(set! js/window.onload main!)
