Object.defineProperty(exports,"__esModule",{value:!0});var _urls=require("./urls"),hasOwnProperty=Object.prototype.hasOwnProperty,assign=Object.assign||function(a){for(var b=1;b<arguments.length;b++){var e=arguments[b],c;for(c in e)hasOwnProperty.call(e,c)&&(a[c]=e[c])}return a},flatten=function(a){return[].concat.apply([],a)},noop=function(){};noop.exec=noop;
var defaults={gfm:!0,tables:!0,breaks:!1,pedantic:!1,smartLists:!0,silent:!1,langPrefix:"lang-",renderer:new Renderer},block={newline:/^\n+/,code:/^( {4}[^\n]+\n*)+/,fences:noop,hr:/^( *[-*_]){3,} *(?:\n+|$)/,heading:/^ *(#{1,6}) *([^\n]+?) *#* *(?:\n+|$)/,nptable:noop,lheading:/^([^\n]+)\n *(=|-){2,} *(?:\n+|$)/,blockquote:/^( *>[^\n]+(\n(?!def)[^\n]+)*\n*)+/,list:/^( *)(bull) [\s\S]+?(?:hr|def|\n{2,}(?! )(?!\1bull )\n*|\s*$)/,def:/^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +["(]([^\n]+)[")])? *(?:\n+|$)/,
paragraph:/^((?:[^\n]+\n?(?!hr|heading|lheading|blockquote|def))+)\n*/,text:/^[^\n]+/,bullet:/(?:[*+-]|\d+\.|\[[x\s]\])/,item:/^( *)(bull) [^\n]*(?:\n(?!\1bull )[^\n]*)*/};block.item=replace(block.item,"gm")(/bull/g,block.bullet)();block.list=replace(block.list)(/bull/g,block.bullet)("hr","\\n+(?\x3d\\1?(?:[-*_] *){3,}(?:\\n+|$))")("def","\\n+(?\x3d"+block.def.source+")")();block.blockquote=replace(block.blockquote)("def",block.def)();
block.paragraph=replace(block.paragraph)("hr",block.hr)("heading",block.heading)("lheading",block.lheading)("blockquote",block.blockquote)("def",block.def)();block.normal=assign({},block);block.gfm=assign({},block.normal,{fences:/^ *(`{3,}|~{3,})[ \.]*(\S+)? *\n([\s\S]+?)\s*\1 *(?:\n+|$)/,paragraph:/^/,heading:/^ *(#{1,6}) +([^\n]+?) *#* *(?:\n+|$)/});block.gfm.paragraph=replace(block.paragraph)("(?!","(?!"+block.gfm.fences.source.replace("\\1","\\2")+"|"+block.list.source.replace("\\1","\\3")+"|")();
block.tables=assign({},block.gfm,{nptable:/^ *(\S.*\|.*)\n *([-:]+ *\|[-| :]*)\n((?:.*\|.*(?:\n|$))*)\n*/,table:/^ *\|(.+)\n *\|( *[-:]+[-| :]*)\n((?: *\|.*(?:\n|$))*)\n*/});function Lexer(a){this.tokens=[];this.tokens.links={};this.options=assign({},a||defaults);this.rules=block.normal;this.options.gfm&&(this.rules=this.options.tables?block.tables:block.gfm)}Lexer.rules=block;Lexer.parse=function(a,b){return(new Lexer(b)).parse(a)};
Lexer.prototype.parse=function(a){a=a.replace(/\r\n|\r/g,"\n").replace(/\t/g,"    ").replace(/\u00a0/g," ").replace(/\u2424/g,"\n");return this.token(a,!0)};
Lexer.prototype.token=function(a,b,e){var c,h,d,k,f,g,l;for(a=a.replace(/^ +$/gm,"");a;){if(d=this.rules.newline.exec(a))a=a.substring(d[0].length),1<d[0].length&&this.tokens.push({type:"space"});if(d=this.rules.code.exec(a))a=a.substring(d[0].length),d=d[0].replace(/^ {4}/gm,""),this.tokens.push({type:"code",text:this.options.pedantic?d:d.replace(/\n+$/,"")});else if(d=this.rules.fences.exec(a))a=a.substring(d[0].length),this.tokens.push({type:"code",lang:d[2],text:d[3]});else if(d=this.rules.heading.exec(a))a=
a.substring(d[0].length),this.tokens.push({type:"heading",depth:d[1].length,text:d[2]});else if(b&&(d=this.rules.nptable.exec(a))){a=a.substring(d[0].length);f={type:"table",header:d[1].replace(/^ *| *\| *$/g,"").split(/ *\| */),align:d[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:d[3].replace(/\n$/,"").split("\n")};for(g=0;g<f.align.length;g++)/^ *-+: *$/.test(f.align[g])?f.align[g]="right":/^ *:-+: *$/.test(f.align[g])?f.align[g]="center":/^ *:-+ *$/.test(f.align[g])?f.align[g]="left":f.align[g]=
null;for(g=0;g<f.cells.length;g++)f.cells[g]=f.cells[g].split(/ *\| */);this.tokens.push(f)}else if(d=this.rules.lheading.exec(a))a=a.substring(d[0].length),this.tokens.push({type:"heading",depth:"\x3d"===d[2]?1:2,text:d[1]});else if(d=this.rules.hr.exec(a))a=a.substring(d[0].length),this.tokens.push({type:"hr"});else if(d=this.rules.blockquote.exec(a))a=a.substring(d[0].length),this.tokens.push({type:"blockquote_start"}),d=d[0].replace(/^ *> ?/gm,""),this.token(d,b,!0),this.tokens.push({type:"blockquote_end"});
else if(d=this.rules.list.exec(a)){a=a.substring(d[0].length);k=d[2];c=1<k.length;var m="["===k[0];this.tokens.push({type:"list_start",style:m?"todo":c?"ordered":"bulleted"});d=d[0].match(this.rules.item);c=!1;l=d.length;for(g=0;g<l;g++){f=d[g];var n=m?!!f.match(/^ *(\[x\])/):void 0;h=f.length;f=f.replace(/^ *([*+-]|\d+\.|\[[x\s]\]) +/,"");~f.indexOf("\n ")&&(h-=f.length,f=this.options.pedantic?f.replace(/^ {1,4}/gm,""):f.replace(new RegExp("^ {1,"+h+"}","gm"),""));this.options.smartLists&&g!==l-
1&&(h=block.bullet.exec(d[g+1])[0],k===h||1<k.length&&1<h.length||(a=d.slice(g+1).join("\n")+a,g=l-1));h=c||/\n\n(?!\s*$)/.test(f);g!==l-1&&(c="\n"===f.charAt(f.length-1),h||(h=c));this.tokens.push({checked:n,type:h?"loose_item_start":"list_item_start"});this.token(f,!1,e);this.tokens.push({type:"list_item_end"})}this.tokens.push({type:"list_end"})}else if(!e&&b&&(d=this.rules.def.exec(a)))a=a.substring(d[0].length),this.tokens.links[d[1].toLowerCase()]={href:d[2],title:d[3]};else if(b&&(d=this.rules.table.exec(a))){a=
a.substring(d[0].length);f={type:"table",header:d[1].replace(/^ *| *\| *$/g,"").split(/ *\| */),align:d[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:d[3].replace(/(?: *\| *)?\n$/,"").split("\n")};for(g=0;g<f.align.length;g++)/^ *-+: *$/.test(f.align[g])?f.align[g]="right":/^ *:-+: *$/.test(f.align[g])?f.align[g]="center":/^ *:-+ *$/.test(f.align[g])?f.align[g]="left":f.align[g]=null;for(g=0;g<f.cells.length;g++)f.cells[g]=f.cells[g].replace(/^ *\| *| *\| *$/g,"").split(/ *\| */);this.tokens.push(f)}else if(b&&
(d=this.rules.paragraph.exec(a)))a=a.substring(d[0].length),this.tokens.push({type:"paragraph",text:"\n"===d[1].charAt(d[1].length-1)?d[1].slice(0,-1):d[1]});else if(d=this.rules.text.exec(a))a=a.substring(d[0].length),this.tokens.push({type:"text",text:d[0]});else if(a)throw Error("Infinite loop on byte: "+a.charCodeAt(0));}return this.tokens};
var inline={escape:/^\\([\\`*{}\[\]()#+\-.!_>])/,link:/^!?\[(inside)\]\(href\)/,reflink:/^!?\[(inside)\]\s*\[([^\]]*)\]/,nolink:/^!?\[((?:\[[^\]]*\]|[^\[\]])*)\]/,strong:/^__([\s\S]+?)__(?!_)|^\*\*([\s\S]+?)\*\*(?!\*)/,em:/^\b_((?:__|[\s\S])+?)_\b|^\*((?:\*\*|[\s\S])+?)\*(?!\*)/,code:/^(`+)\s*([\s\S]*?[^`])\s*\1(?!`)/,br:/^ {2,}\n(?!\s*$)/,del:noop,ins:noop,text:/^[\s\S]+?(?=[\\<!\[_*`]| {2,}\n|$)/,_inside:/(?:\[[^\]]*\]|[^\[\]]|\](?=[^\[]*\]))*/,_href:/\s*<?([\s\S]*?)>?(?:\s+['"]([\s\S]*?)['"])?\s*/};
inline.link=replace(inline.link)("inside",inline._inside)("href",inline._href)();inline.reflink=replace(inline.reflink)("inside",inline._inside)();inline.normal=assign({},inline);inline.pedantic=assign({},inline.normal,{strong:/^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,em:/^_(?=\S)([\s\S]*?\S)_(?!_)|^\*(?=\S)([\s\S]*?\S)\*(?!\*)/});
inline.gfm=assign({},inline.normal,{escape:replace(inline.escape)("])","~|])")(),del:/^~~(?=\S)([\s\S]*?\S)~~/,ins:/^\+\+(?=\S)([\s\S]*?\S)\+\+/,text:replace(inline.text)("]|","~+]|")()});inline.breaks=assign({},inline.gfm,{br:replace(inline.br)("{2,}","*")(),text:replace(inline.gfm.text)("{2,}","*")()});
function InlineLexer(a,b){this.options=assign({},b||defaults);this.links=a;this.rules=inline.normal;this.renderer=this.options.renderer||new Renderer;this.renderer.options=this.options;if(!this.links)throw Error("Tokens array requires a `links` property.");this.options.gfm?this.rules=this.options.breaks?inline.breaks:inline.gfm:this.options.pedantic&&(this.rules=inline.pedantic)}InlineLexer.rules=inline;InlineLexer.parse=function(a,b,e){return(new InlineLexer(b,e)).parse(a)};
InlineLexer.prototype.parse=function(a){for(var b=[],e,c;a;)if(c=this.rules.escape.exec(a))a=a.substring(c[0].length),b.push({kind:"text",ranges:[{text:c[1]}]});else if(c=this.rules.link.exec(a))a=a.substring(c[0].length),this.inLink=!0,b.push(this.outputLink(c,{href:c[2],title:c[3]})),this.inLink=!1;else if((c=this.rules.reflink.exec(a))||(c=this.rules.nolink.exec(a)))a=a.substring(c[0].length),e=(c[2]||c[1]).replace(/\s+/g," "),(e=this.links[e.toLowerCase()])&&e.href?(this.inLink=!0,b.push(this.outputLink(c,
e)),this.inLink=!1):(b.push({kind:"text",ranges:[{text:c[0].charAt(0)}]}),a=c[0].substring(1)+a);else if(c=this.rules.strong.exec(a))a=a.substring(c[0].length),b.push(this.renderer.strong(this.parse(c[2]||c[1])));else if(c=this.rules.em.exec(a))a=a.substring(c[0].length),b.push(this.renderer.em(this.parse(c[2]||c[1])));else if(c=this.rules.code.exec(a))a=a.substring(c[0].length),b.push(this.renderer.codespan(c[2]));else if(c=this.rules.br.exec(a))a=a.substring(c[0].length),b.push(this.renderer.br());
else if(c=this.rules.del.exec(a))a=a.substring(c[0].length),b.push(this.renderer.del(this.parse(c[1])));else if(c=this.rules.ins.exec(a))a=a.substring(c[0].length),b.push(this.renderer.ins(this.parse(c[1])));else if(c=this.rules.text.exec(a))a=a.substring(c[0].length),b.push(this.renderer.text(c[0]));else if(a)throw Error("Infinite loop on byte: "+a.charCodeAt(0));return b};
InlineLexer.prototype.outputLink=function(a,b){var e=b.href,c=b.title;return"!"!==a[0].charAt(0)?this.renderer.link(e,c,this.parse(a[1])):this.renderer.image(e,c,a[1])};"";function Renderer(a){this.options=a||{}}
Renderer.prototype.groupTextInRanges=function(a){var b=this;return flatten(a).reduce(function(a,c){var h=a.length-1,d=0<=h&&a[h]&&"text"===a[h].kind;if(c instanceof TextNode)return d?a[h].ranges.push(c):a.push({kind:"text",ranges:[c]}),a;if(c instanceof Array)return a.concat(b.groupTextInRanges(c));a.push(c);return a},[])};Renderer.prototype.code=function(a,b){var e={};b&&(e.language=this.options.langPrefix+b);return{kind:"block",type:"code",data:e,nodes:this.groupTextInRanges(a)}};
Renderer.prototype.blockquote=function(a){return{kind:"block",type:"block-quote",nodes:this.groupTextInRanges(a)}};Renderer.prototype.heading=function(a,b){return{kind:"block",type:"heading"+b,nodes:this.groupTextInRanges(a)}};Renderer.prototype.hr=function(){return{kind:"block",type:"horizontal-rule",nodes:[{kind:"text",ranges:[{text:""}]}],isVoid:!0}};Renderer.prototype.list=function(a,b){return{kind:"block",type:b+"-list",nodes:this.groupTextInRanges(a)}};
Renderer.prototype.listitem=function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},e=void 0;void 0!==b.checked&&(e={checked:b.checked});return{kind:"block",type:"list-item",data:e,nodes:this.groupTextInRanges(a)}};Renderer.prototype.paragraph=function(a){return{kind:"block",type:"paragraph",nodes:this.groupTextInRanges(a)}};Renderer.prototype.table=function(a){return{kind:"block",type:"table",nodes:a}};
Renderer.prototype.tablerow=function(a){return{kind:"block",type:"table-row",nodes:a}};Renderer.prototype.tablecell=function(a,b){return{kind:"block",data:{align:b.align},type:b.header?"table-head":"table-cell",nodes:this.groupTextInRanges(a)}};Renderer.prototype.strong=function(a){return a.map(function(a){a.marks?a.marks.push({type:"bold"}):a.marks=[{type:"bold"}];return a})};
Renderer.prototype.em=function(a){return a.map(function(a){a.marks?a.marks.push({type:"italic"}):a.marks=[{type:"italic"}];return a})};Renderer.prototype.codespan=function(a){return new TextNode(a,{type:"code"})};Renderer.prototype.br=function(){return new TextNode("")};Renderer.prototype.del=function(a){return a.map(function(a){a.marks?a.marks.push({type:"deleted"}):a.marks=[{type:"deleted"}];return a})};
Renderer.prototype.ins=function(a){return a.map(function(a){a.marks?a.marks.push({type:"inserted"}):a.marks=[{type:"inserted"}];return a})};Renderer.prototype.link=function(a,b,e){a={href:(0,_urls.decode)(a)};b&&(a.title=b);return{kind:"inline",type:"link",nodes:this.groupTextInRanges(e),data:a}};Renderer.prototype.image=function(a,b,e){a={src:(0,_urls.decode)(a)};b&&(a.title=b);e&&(a.alt=e);return{kind:"block",type:"image",nodes:[{kind:"text",ranges:[{text:""}]}],isVoid:!0,data:a}};
Renderer.prototype.text=function(a){return new TextNode(a)};function TextNode(a,b){this.text=a;b&&(this.marks=[b])}function Parser(a){this.tokens=[];this.token=null;this.options=assign({},a||defaults);this.options.renderer=this.options.renderer||new Renderer;this.renderer=this.options.renderer;this.renderer.options=this.options}Parser.parse=function(a,b,e){return(new Parser(b,e)).parse(a)};
Parser.prototype.parse=function(a){this.inline=new InlineLexer(a.links,this.options,this.renderer);this.tokens=a.slice().reverse();for(a=[];this.next();)a.push(this.tok());return a};Parser.prototype.next=function(){return this.token=this.tokens.pop()};Parser.prototype.peek=function(){return this.tokens[this.tokens.length-1]||0};Parser.prototype.parseText=function(){for(var a=this.token.text;"text"===this.peek().type;)a+="\n"+this.next().text;return this.inline.parse(a)};
Parser.prototype.tok=function(){switch(this.token.type){case "space":return{kind:"text",ranges:[{text:""}]};case "hr":return this.renderer.hr();case "heading":return this.renderer.heading(this.inline.parse(this.token.text),this.token.depth);case "code":return this.renderer.code(this.inline.parse(this.token.text),this.token.lang);case "table":for(var a=[],b=void 0,e=void 0,c=void 0,e=[],b=0;b<this.token.header.length;b++)e.push(this.renderer.tablecell(this.inline.parse(this.token.header[b]),{header:!0,
align:this.token.align[b]}));a.push(this.renderer.tablerow(e));for(b=0;b<this.token.cells.length;b++){for(var e=this.token.cells[b],h=[],c=0;c<e.length;c++)h.push(this.renderer.tablecell(this.inline.parse(e[c]),{header:!1,align:this.token.align[c]}));a.push(this.renderer.tablerow(h))}return this.renderer.table(a);case "blockquote_start":for(a=[];"blockquote_end"!==this.next().type;)a.push(this.inline.parse(this.token.text));return this.renderer.blockquote(a);case "list_start":a=[];for(b=this.token.style;"list_end"!==
this.next().type;)a.push(this.tok());return this.renderer.list(a,b);case "loose_item_start":case "list_item_start":a=[];for(b={checked:this.token.checked};"list_item_end"!==this.next().type;)a.push("text"===this.token.type?this.parseText():this.tok());return this.renderer.listitem(a,b);case "paragraph":return this.renderer.paragraph(this.inline.parse(this.token.text));case "text":return this.renderer.text(this.parseText())}};
function replace(a,b){a=a.source;b=b||"";return function c(h,d){if(!h)return new RegExp(a,b);d=d.source||d;d=d.replace(/(^|[^\[])\^/g,"$1");a=a.replace(h,d);return c}}var MarkdownParser={parse:function(a,b){b=assign({},defaults,b);try{var e=Parser.parse(Lexer.parse(a,b),b)}catch(c){if(b.silent)e=[{kind:"block",type:"paragraph",nodes:[{kind:"text",ranges:[{text:"An error occured:"},{text:c.message}]}]}];else throw c;}return{nodes:e}}};exports.default=MarkdownParser;