(ns reify.tokamak.protocols)

(defprotocol IMachine
  "Implementers of IMachine are static/fixed descriptions of state and its
   evolution with respect to an action stream."
  (initial-state [m])
  (state-schema [m])
  (reducer [m]))

(defprotocol IView
  "The IView behavior lets a value describe a way of observing a subpart of a
  whole. Primitive values become indexes or equality tests, functions are
  applied *in media res*, sequences of various types translate to views applied
  in order (thus, rose trees of vectors, e.g., apply their views in depth-first
  traversal), maps apply views *in parallel* or *confluently* producing a map
  of each viewed value.

  Most notably, views which are deref-able are deref'd when viewed. This
  allows views to be dependent, e.g., on reactions or ratoms in reagent."

  (-view [v s default]))