(ns reify.tokamak.impl.util
  (:require
    [schema.core :include-macros true]
    [goog.object :as o]))

(defn prop-type-any [_props _propName _componentName])

(defn shallow-clj->js
  "Convert a Clojure map to a Javascript object *shallowly*. This can be used
   to pass arguments to Javascript functions which expect objects of certain
   shapes but are *invariant* to the deeper contents. If `clj->js` were to be
   used instead it would destroy the Clojure objects being passed in."
  [map]
  (let [o #js{}]
    (doseq [[k v] map]
      (aset o (name k) v))
    o))

(defn shallow-js->clj
  "Convert a Javascript object into a Clojure map *shallowly*. See
   `shallow-clj->js`."
  [o]
  (let [kseq (o/getKeys o)]
    (into {} (map (fn [k] [(keyword k) (aget o k)]) kseq))))