(ns reify.tokamak.impl.context)

(defmacro with-context
  "Produces a DOM-free component which accesses the DOM context. A component
  `(with-contenxt [x :x] ...)` has access to the contextual value stored at key
  `:x` in its body."
  [bindings & body]
  (assert (even? (count bindings)))
  (let [names (take-nth 2 bindings)
        keys (take-nth 2 (rest bindings))]
    `(reify.tokamak.context/given-context
       ~(vec keys)
       (fn ~(vec names) ~@body))))