(ns reify.bslite.navbar
  (:require
    [reify.bslite.util :refer [VTree classnames label]]
    #?(:cljs [cljs.core.match :refer-macros [match]]
       :clj  [clojure.core.match :refer  [match]])
    [schema.core :as s :include-macros true]))

(s/defn navbar :- VTree
  [attrs :- {}
   & children :- [VTree]]
  [:nav.navbar.navbar-default
   [:div.container-fluid (label children)]])

(s/defschema CollapsingAttrs
  {(s/optional-key :id) s/Str})

(s/defn collapsing :- VTree
  [attrs :- CollapsingAttrs
   & children :- [VTree]]
  [:div.collapse.navbar-collpase attrs (label children)])

(s/defschema HamburgerButtonAttrs
  {(s/optional-key :target) s/Str
   (s/optional-key :alt) s/Str})

(s/defn hamburger-button :- VTree
  [{:keys [target alt]} :- HamburgerButtonAttrs]
  [:button.navbar-toggle.collapsed {:type :button :data-target target}
   [:span.sr-only alt]
   [:span.icon-bar]
   [:span.icon-bar]
   [:span.icon-bar]])

(s/defschema GroupAttrs
  {(s/optional-key :right-justify) s/Bool})

(s/defn group :- VTree
  [{:keys [right-justify] :or {right-justify false}} :- GroupAttrs
   & children :- [VTree]]
  [:ul.nav.navbar-nav
   {:class (classnames {:navbar-right right-justify})}
   (label children)])

(s/defn header :- VTree
  [attrs :- {}
   & children :- [VTree]]
  [:div.navbar-header (label children)])

(s/defschema BrandAttrs
  {(s/optional-key :alt) s/Str
   (s/optional-key :href) s/Str
   (s/optional-key :on-click) (s/=> s/Any s/Any)})

(s/defn brand :- VTree
  [{:keys [alt href on-click]
    :or {href "#"}} :- BrandAttrs
   & children :- [VTree]]
  [:a.navbar-brand {:alt alt :href href :on-click on-click} (label children)])

(s/defschema ItemAttrs
  {(s/optional-key :active) s/Bool
   (s/optional-key :href) s/Str
   (s/optional-key :name) s/Str
   (s/optional-key :on-click) (s/=> s/Any s/Any)})

(s/defn item :- VTree
  [{:keys [href active on-click]
    :or {active false}} :- ItemAttrs
   name :- s/Str]
  (let [is-link (or (not (nil? on-click))
                    (not (nil? href)))
        href (or href "#")]
    (match [active is-link]
      [true true]
      [:li.active {:on-click on-click}
       [:a {:href href} name [:span.sr-only "(current)"]]]

      [true false]
      [:li.active {:on-click on-click} name [:span.sr-only "(current)"]]

      [false true]
      [:li {:on-click on-click} [:a {:href href} name]]

      [false false]
      [:li {:on-click on-click} name])))

(s/defn divider :- VTree
  [attrs :- {}]
  [:li.divider])

(s/defschema DropdownAttrs
  {(s/optional-key :name) s/Str})

(s/defn dropdown :- VTree
  [{:keys [name]
    :or {name "Dropdown"}} :- DropdownAttrs
   & children :- [VTree]
   ]
  [:li.dropdown
   [:a.dropdown-toggle
    {:href "#"
     :data-toggle "dropdown"
     :role :button
     :aria-expanded false}
    name [:span.caret]]
   [:ul.dropdown-menu {:role :menu} (label children)]
   ])

(s/defn text :- VTree
  [text :- s/Str]
  [:p.navbar-text text])

