/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTransaction
extends Queable {
    protected Client client = null;
    protected boolean inTransaction = true;

    public BinaryTransaction() {
    }

    public BinaryTransaction(Client client) {
        this.client = client;
    }

    public List<Object> exec() {
        this.client.exec();
        this.client.getAll(1);
        List<Object> unformatted = this.client.getObjectMultiBulkReply();
        if (unformatted == null) {
            return null;
        }
        ArrayList<Object> formatted = new ArrayList<Object>();
        for (Object o : unformatted) {
            formatted.add(this.generateResponse(o).get());
        }
        return formatted;
    }

    public String discard() {
        this.client.discard();
        this.client.getAll(1);
        this.inTransaction = false;
        this.clean();
        return this.client.getStatusCodeReply();
    }

    public Response<Long> append(byte[] key, byte[] value) {
        this.client.append(key, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<List<String>> blpop(byte[] ... args) {
        this.client.blpop(args);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<List<String>> brpop(byte[] ... args) {
        this.client.brpop(args);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Long> decr(byte[] key) {
        this.client.decr(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> decrBy(byte[] key, long integer) {
        this.client.decrBy(key, integer);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> del(byte[] ... keys) {
        this.client.del(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> echo(byte[] string) {
        this.client.echo(string);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Boolean> exists(byte[] key) {
        this.client.exists(key);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Long> expire(byte[] key, int seconds) {
        this.client.expire(key, seconds);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> expireAt(byte[] key, long unixTime) {
        this.client.expireAt(key, unixTime);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> get(byte[] key) {
        this.client.get(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> getSet(byte[] key, byte[] value) {
        this.client.getSet(key, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> hdel(byte[] key, byte[] field) {
        this.client.hdel(key, field);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Boolean> hexists(byte[] key, byte[] field) {
        this.client.hexists(key, field);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<String> hget(byte[] key, byte[] field) {
        this.client.hget(key, field);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Map<String, String>> hgetAll(byte[] key) {
        this.client.hgetAll(key);
        return this.getResponse(BuilderFactory.STRING_MAP);
    }

    public Response<Long> hincrBy(byte[] key, byte[] field, long value) {
        this.client.hincrBy(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> hkeys(byte[] key) {
        this.client.hkeys(key);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Long> hlen(byte[] key) {
        this.client.hlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<List<String>> hmget(byte[] key, byte[] ... fields) {
        this.client.hmget(key, fields);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<String> hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.client.hmset(key, hash);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> hset(byte[] key, byte[] field, byte[] value) {
        this.client.hset(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> hsetnx(byte[] key, byte[] field, byte[] value) {
        this.client.hsetnx(key, field, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<List<String>> hvals(byte[] key) {
        this.client.hvals(key);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Long> incr(byte[] key) {
        this.client.incr(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> incrBy(byte[] key, long integer) {
        this.client.incrBy(key, integer);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> keys(byte[] pattern) {
        this.client.keys(pattern);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<String> lindex(byte[] key, int index) {
        this.client.lindex(key, index);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        this.client.linsert(key, where, pivot, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> llen(byte[] key) {
        this.client.llen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> lpop(byte[] key) {
        this.client.lpop(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> lpush(byte[] key, byte[] string) {
        this.client.lpush(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> lpushx(byte[] key, byte[] bytes) {
        this.client.lpushx(key, bytes);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<List<String>> lrange(byte[] key, int start, int end) {
        this.client.lrange(key, start, end);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Long> lrem(byte[] key, int count, byte[] value) {
        this.client.lrem(key, count, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> lset(byte[] key, int index, byte[] value) {
        this.client.lset(key, index, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> ltrim(byte[] key, int start, int end) {
        this.client.ltrim(key, start, end);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<List<String>> mget(byte[] ... keys) {
        this.client.mget(keys);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Long> move(byte[] key, int dbIndex) {
        this.client.move(key, dbIndex);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> mset(byte[] ... keysvalues) {
        this.client.mset(keysvalues);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> msetnx(byte[] ... keysvalues) {
        this.client.msetnx(keysvalues);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> persist(byte[] key) {
        this.client.persist(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> rename(byte[] oldkey, byte[] newkey) {
        this.client.rename(oldkey, newkey);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> renamenx(byte[] oldkey, byte[] newkey) {
        this.client.renamenx(oldkey, newkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> rpop(byte[] key) {
        this.client.rpop(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> rpoplpush(byte[] srckey, byte[] dstkey) {
        this.client.rpoplpush(srckey, dstkey);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> rpush(byte[] key, byte[] string) {
        this.client.rpush(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> rpushx(byte[] key, byte[] string) {
        this.client.rpushx(key, string);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> sadd(byte[] key, byte[] member) {
        this.client.sadd(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> scard(byte[] key) {
        this.client.scard(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> sdiff(byte[] ... keys) {
        this.client.sdiff(keys);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Long> sdiffstore(byte[] dstkey, byte[] ... keys) {
        this.client.sdiffstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> set(byte[] key, byte[] value) {
        this.client.set(key, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Boolean> setbit(String key, long offset, boolean value) {
        this.client.setbit(key, offset, value);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<String> setex(byte[] key, int seconds, byte[] value) {
        this.client.setex(key, seconds, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> setnx(byte[] key, byte[] value) {
        this.client.setnx(key, value);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> sinter(byte[] ... keys) {
        this.client.sinter(keys);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Long> sinterstore(byte[] dstkey, byte[] ... keys) {
        this.client.sinterstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Boolean> sismember(byte[] key, byte[] member) {
        this.client.sismember(key, member);
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Set<String>> smembers(byte[] key) {
        this.client.smembers(key);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Long> smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.client.smove(srckey, dstkey, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<List<String>> sort(byte[] key) {
        this.client.sort(key);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<List<String>> sort(byte[] key, SortingParams sortingParameters) {
        this.client.sort(key, sortingParameters);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<List<String>> sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        this.client.sort(key, sortingParameters, dstkey);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<List<String>> sort(byte[] key, byte[] dstkey) {
        this.client.sort(key, dstkey);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<String> spop(byte[] key) {
        this.client.spop(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> srandmember(byte[] key) {
        this.client.srandmember(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> srem(byte[] key, byte[] member) {
        this.client.srem(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> strlen(byte[] key) {
        this.client.strlen(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> substr(byte[] key, int start, int end) {
        this.client.substr(key, start, end);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Set<String>> sunion(byte[] ... keys) {
        this.client.sunion(keys);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Long> sunionstore(byte[] dstkey, byte[] ... keys) {
        this.client.sunionstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> ttl(byte[] key) {
        this.client.ttl(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> type(byte[] key) {
        this.client.type(key);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> watch(byte[] ... keys) {
        this.client.watch(keys);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> zadd(byte[] key, double score, byte[] member) {
        this.client.zadd(key, score, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zcard(byte[] key) {
        this.client.zcard(key);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zcount(byte[] key, double min, double max) {
        this.client.zcount(key, min, max);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Double> zincrby(byte[] key, double score, byte[] member) {
        this.client.zincrby(key, score, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<Long> zinterstore(byte[] dstkey, byte[] ... sets) {
        this.client.zinterstore(dstkey, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.client.zinterstore(dstkey, params, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> zrange(byte[] key, int start, int end) {
        this.client.zrange(key, start, end);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<String>> zrangeByScore(byte[] key, double min, double max) {
        this.client.zrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<String>> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.client.zrangeByScore(key, min, max);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<String>> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        this.client.zrangeByScore(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max) {
        this.client.zrangeByScoreWithScores(key, min, max);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Set<Tuple>> zrangeWithScores(byte[] key, int start, int end) {
        this.client.zrangeWithScores(key, start, end);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Long> zrank(byte[] key, byte[] member) {
        this.client.zrank(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zrem(byte[] key, byte[] member) {
        this.client.zrem(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zremrangeByRank(byte[] key, int start, int end) {
        this.client.zremrangeByRank(key, start, end);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zremrangeByScore(byte[] key, double start, double end) {
        this.client.zremrangeByScore(key, start, end);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> zrevrange(byte[] key, int start, int end) {
        this.client.zrevrange(key, start, end);
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<Tuple>> zrevrangeWithScores(byte[] key, int start, int end) {
        this.client.zrevrangeWithScores(key, start, end);
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Long> zrevrank(byte[] key, byte[] member) {
        this.client.zrevrank(key, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Double> zscore(byte[] key, byte[] member) {
        this.client.zscore(key, member);
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<Long> zunionstore(byte[] dstkey, byte[] ... sets) {
        this.client.zunionstore(dstkey, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.client.zunionstore(dstkey, params, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        return this.getResponse(BuilderFactory.STRING);
    }
}

