(def project 'com.recursionpharma/{{ name }})
(def version "0.1.0-SNAPSHOT")

(set-env!
  :resource-paths #{"resources" "src"}
  :source-paths   #{"test"}
  :wagons '[[s3-wagon-private "1.2.0"]]
  :repositories #(conj % ["recursion" {:url "s3p://recursion-jars/"
                                       :username (System/getenv "AWS_ACCESS_KEY_ID")
                                       :passphrase (System/getenv "AWS_SECRET_ACCESS_KEY")}])
  :dependencies
  '[[org.clojure/clojure "1.9.0-alpha17" :scope "provided"]
    [org.clojure/tools.logging "0.4.0"]

    ;; Library Dependencies{{{deps}}}

    ;; Test and Development Dependencies
    [adzerk/boot-test "1.2.0" :scope "test"]{{{test-deps}}}])

(task-options!
 pom {:project     project
      :version     version
      :description "FIXME: write description"
      :url         "https://github.com/recursionpharma/{{ name }}"
      :scm         {:url "https://github.com/recursionpharma/{{ name }}"}}
 push {:repo "recursion"
       :ensure-clean true
       :ensure-branch "master"})

(deftask build
  "Build and install the project locally."
  []
  (comp (pom) (jar) (install)))

(deftask release
  "Build and release a new version of the library."
  []
  (comp (pom) (jar) (push)))

(require '[adzerk.boot-test :refer [test]])
