(ns {{ name }}.web
  (:require [compojure.api.middleware :as c.middleware]
            [compojure.api.sweet :as c]
            ring.logger

            [{{ name }} :as a]))

(def api-routes
  (c/api
    {:coercion :spec
     :swagger
     {:ui "/"
      :spec "/swagger.json"
      :data {:info {:title "{{ name }} API"
                    :description "TODO: Describe your api here"}}}}

    (c/GET "/hello/:name" []
      :summary "returns a basic hello response"
      :path-params [name :- ::a/name]
      :components [{{#postgres}}db{{/postgres}}] ;; Components added to the resources component in core can be referenced here
      :return ::a/hello-response
      {:status 200 :body {:hello name}})))

(defn build-handler [{:keys [config resources]}]
  (-> api-routes
      (c.middleware/wrap-components resources)
      (ring.logger/wrap-with-logger {:printer :no-color
                                     :redact-keys #{:authorization :password :cookie :Set-Cookie}
                                     :redact-value "**redacted**"})))
