(ns dev
  (:require [clojure.repl :refer [apropos dir doc find-doc pst source]]
            [clojure.tools.logging :as log]

            [com.stuartsierra.component :as component]

            [{{ name }}.core :as core]))

(defonce system nil)

(defn dev-config []
  (core/load-config "config/config-dev.clj" "config/config-dev.sample.clj"))

(defn init []
  (->> (dev-config)
       core/system-component
       constantly
       (alter-var-root #'system)))

(defn start []
  (alter-var-root #'system component/start)
  :started)

(defn stop []
  (when system
    (alter-var-root #'system component/stop))
  :stopped)

(defn go []
  (stop) (init) (start) :ready)

(defn clean []
  (when (component/ex-component? *e)
    (-> *e ex-data :system component/stop))
  :cleaned)
