#!/bin/bash

set -e
set -x

if [ "$TRAVIS_PULL_REQUEST" = "false" && "$TRAVIS_BRANCH" = "master" ]; then
  tag=$(git rev-parse HEAD | cut -c 1-10)
  project="eng-infrastructure"
  cluster="primary"
  registry="gcr.io/$project"
  zone="us-west1-b"
  name="{{ name }}"

  boot build
  docker build -t $name:$tag .

  docker tag $name:$tag $registry/$name:$tag
  gcloud docker -- push $registry/$name:$tag

  docker tag $name:$tag $registry/$name:latest
  gcloud docker -- push $registry/$name:latest

  gcloud container clusters get-credentials $cluster --zone $zone --project $project

  current_image="$(kubectl describe deployment $name | grep -E "Image:.*$name" | sed -E 's/.*[[:space:]]+//g')"
  new_image="$registry/$name:$tag"
  if [[ "$current_image" == "$new_image" ]]; then
    echo "$new_image is already running in kubernetes."
    exit 0
  fi

  kubectl set image deployment/$name $name=$new_image

  printf 'deployments,app=%s image="%s"' $name $name:$tag > line.tmp.txt
  curl -i -X POST --data-binary @line.tmp.txt 'https://metrics.recursionpharma.com:8086/write?db=metrics'
  rm line.tmp.txt
fi
