# {{ name }}

TODO: write description of this application here

## Development

The default development configuration is found in `config/config-dev.sample.clj`.
In order to override those settings, copy `config/config-dev.sample.clj` to `config/config-dev.clj`
and modify that file.

The application is composed in `{{ name }}.core/system-component` using the [component library][component].
An instance can be conveniently started/restarted from a repl with `(dev/go)`
and thereafter can be accessed using the `dev/system` var.

If you need to run a development system, but don't plan on developing, then `boot run`
will simply run the development system.
{{#postgres}}

The default database configuration assumes a locally available postgres instance with a
database named `{{ sanitized }}` available without authentication. This can easily be adjusted in
the `config/config-dev.clj` file for development purposes.

The tests will assume a locally running database name `{{ sanitized }}_test` that is available
without authentication. If you decide to change this, it will probably break the travis ci setup.

We are using [boot-ragtime][boot-ragtime] for migrations. The migrations are stored in `resources/migrations`.
For more info run `boot ragtime --help`
{{/postgres}}
{{#web}}

The web handler is built using [compojure-api][compojure-api]. The entry point can be found at `{{ name }}.web/api-routes`.
A [Swagger UI](http://localhost:8080/) is served to document and explore the web api.
{{/web}}

## Deployment

Almost everything is in place in order for [travis-ci][travis-ci] to automatically run the tests for each commit
and also to deploy the application for each new set of commits on the master branch. There are some
final pieces that need to be put in place for travis to have access to all of the resources that are
needed for this all to work.

  - Install the [travis commandline application](https://github.com/travis-ci/travis.rb#installation).
  - Push this project to github.
  - Enable the project on Travis using `travis enable` from the project directory.
  - Using LastPass grab the attached file `secrets.tar` from the `travis-ci secrets.tar` entry in the Shared-Eng folder and move into the top level of this project.
  - You can optionally add any other secret files to `secrets.tar` with `tar -rf secrets.tar <file-to-add>`.
  - Encrypt `secrets.tar` using `travis encrypt-file secrets.tar` and make sure to follow the instructions that are output.
  - Travis should now be continuously testing and deploying you application, the deployment details can be reviewed in `deploy.sh` and assume there is a deployment named {{ name }} on the kubernetes cluster.

## License

This is proprietary software.

Copyright © {{ year }} Recursion Pharmaceuticals

[ragtime]: https://github.com/mbuczko/boot-ragtime
[compojure-api]: https://github.com/metosin/compojure-api
[component]: https://github.com/stuartsierra/component
[travis-ci]: https://travis-ci.com
