(ns {{ns-name}}.session
  (:require [reagent.core :as reagent :refer [atom]]))

;; ----------
;; State
(def {{ns-name}}-state (atom {}))

;; ----------
;; Helper Functions
(defn get-state [k & [default]]
  (clojure.core/get @{{ns-name}}-state k default))

(defn put! [k v]
  (swap! {{ns-name}}-state assoc k v))

;; ----------
;; Get State
(defn current-page []
  (get-state :current-page))

(defn nav []
  (get-state :nav))
