(ns buckshot.worker
  (:require [buckshot.backend :as backend]
            [buckshot.util :as util]))

(defprotocol IWorker
  (start! [this])
  (stop!  [this]))

(defn- wrap [f middleware]
  (let [g (reduce (fn [acc mid] (mid acc))
                  (fn [data] (apply f (-> data :job :args)))
                  middleware)]
    (fn [data] (g data))))

(defn- handle-job! [worker job]
  (let [f (get (:fn-map worker) (:fn job))
        wrapped-f (wrap f (-> worker :opts :middleware))]
    (wrapped-f {:job job :worker worker})))

(defrecord Worker [active? backend fn-map opts]
  IWorker
  (start! [this]
    (when-not @active?
      (reset! active? true)
      (future (while @active?
                (try (if-let [j (backend/next-job backend (:queues opts))]
                       (if (backend/claim-job! backend j (:id opts))
                         (handle-job! this j)
                         (let [sleep-ms (rand-int 1000)]
                           (util/log! :sleep this {:duration sleep-ms})
                           (Thread/sleep sleep-ms)))
                       (let [sleep-ms (:sleep opts)]
                         (util/log! :sleep this {:duration sleep-ms})
                         (Thread/sleep sleep-ms)))
                     (catch Throwable t
                       (when-let [handler (:exception-handler opts)]
                         (handler t)))))))
    true)
  (stop! [_]
    (reset! active? false)
    true))
