(ns buckshot.worker
  (:require [buckshot.backend :as backend]))

(defprotocol IWorker
  (start! [this])
  (stop!  [this]))

(defn- wrap [f middleware]
  (let [g (reduce (fn [acc mid] (mid acc))
                  (fn [data] (apply f (-> data :job :args)))
                  middleware)]
    (fn [data] (g data))))

(defn- handle-job! [worker job]
  (let [b (:backend worker)
        f (get (:fn-map worker) (:fn job))
        wrapped-f (wrap f (-> worker :opts :middleware))
        result (wrapped-f {:job job :worker worker})]
    (backend/publish! b (:id job) result)
    (backend/del-job! b job)))

(defrecord Worker [active? backend fn-map opts]
  IWorker
  (start! [this]
    (when-not @active?
      (reset! active? true)
      (future (while @active?
                (try (if-let [j (backend/next-job backend (:queues opts))]
                       (if (backend/claim-job! backend j)
                         (handle-job! this j)
                         (Thread/sleep (rand-int 1000)))
                       (Thread/sleep (:sleep opts)))
                     (catch Throwable t
                       (when-let [handler (:exception-handler opts)]
                         (handler t)))))))
    true)
  (stop! [_]
    (reset! active? false)
    true))
