(ns buckshot.backend)

(defprotocol IBackend
  (colls [this])
  (atomically [this colls f])
  (hall [this hash])
  (hget [this hash key])
  (hadd! [this hash key value])
  (hrem! [this hash key])
  (zall [this set])
  (zmin [this set max-key])
  (zexists? [this set value])
  (zadd! [this set key value])
  (zrem! [this set value])
  (publish! [this channel message])
  (subscribe! [this channel f]))

(load "backends/in_memory")
(load "backends/redis")
