(ns buckshot.util
  (:require [clj-time.core :as time]
            [clj-time.coerce :as time-coerce]))

(defn now-ms []
  (time-coerce/to-long (time/now)))

(defn today-ms []
  (let [now (time/now)]
    (time-coerce/to-long (time/date-time (time/year now)
                                         (time/month now)
                                         (time/day now)))))

(defn rand-id []
  (str (.getHostName (java.net.InetAddress/getLocalHost)) ":"
       (System/currentTimeMillis) ":"
       (java.util.UUID/randomUUID)))
