(ns buckshot.demo
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.util :as util]
            [buckshot.worker :as worker]))

;; init
(def backend (backend/make-in-memory {}))

(def queue (queue/make {:backend backend}))

(buckshot/add-log-handler! queue println)

(def worker (worker/make {:id 0
                          :fns {:add (fn [& xs] (apply + xs))
                                :bad #(throw (Exception. "bad"))
                                :schedule-jobs #(queue/schedule-jobs! queue)}
                          :queue queue}))

(defn status-check []
  (println "specs:" (queue/specs queue))
  (println "scheduled:" (queue/scheduled queue))
  (println "processing:" (queue/processing queue)))

(status-check)

;; one-time task
(def p (buckshot/send! queue :add [1 1]))

(deref p)

;; task exception
(buckshot/send! queue :bad nil)

(->> (queue/processing queue)
     first
     (queue/finish-job! queue))

;; recurring task
(buckshot/send! queue :schedule-jobs nil :period :second)

(worker/stop! worker)

(->> (queue/specs queue)
     first
     (queue/remove-spec! queue))

(worker/start! worker)

;; unknown job should not block everything
(buckshot/send! queue :unknown nil)

(def p (buckshot/send! queue :add [1 2 3]))

(deref p)

(->> (queue/specs queue)
     first
     (queue/remove-spec! queue))

(status-check)
