(ns test
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [taoensso.carmine :as redis]))

;;(def host "10.0.36.17")
(def host "10.0.56.105")
;;(def host "127.0.0.1")

(def pool (redis/make-conn-pool))

(def spec (redis/make-conn-spec :host host))

(defmacro wredis [& body]
  `(redis/with-conn pool spec ~@body))

(sort (wredis (redis/keys "*")))

(pprint (wredis (redis/hvals "recurring")))

(->> (wredis (redis/hvals "one-time"))
     (map :fn)
     frequencies)

(->> (wredis (redis/zrange "processing" 0 -1))
     (map :fn)
     frequencies)

(def q (queue/make {:backend (backend/make-redis {:host host})}))
