(ns test
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.tasks :as tasks]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [taoensso.carmine :as redis]))

(def pool (redis/make-conn-pool))

(def spec (redis/make-conn-spec :host "10.0.36.17"))

(defmacro wredis [& body]
  `(redis/with-conn pool spec ~@body))

(-> (wredis (redis/client-list))
    (clojure.string/split #"\n")
    ;;    count
    clojure.pprint/pprint
    )

;;(wredis (redis/flushall))
;;(wredis (redis/del "one-time"))
;;(wredis (redis/del "adder"))

(def q (queue/make {:backend (backend/make-redis {})}))

(def total 10)

(def responses (atom nil))

(def results (atom nil))

(def specs (for [i (range total)]
             {:id (str i)
              :fn :adder
              :args [i]}))

(doseq [s specs]
  (queue/subscribe! q (:id s) (fn [x]
                                (swap! results conj x))))

(add-watch responses :watch (fn [k r old new]
                              (when (= total (count new))
                                (println "scheduled" (java.util.Date.)))))

(add-watch results :watch (fn [k r old new]
                            (when (= total (count new))
                              (println "finished" (java.util.Date.)))))

(let [size (/ (count specs) 256)]
  (println "started" (java.util.Date.))
  (doseq [chunk (partition-all size specs)]
    (future
      (doseq [s chunk]
        (let [r (try
                  (queue/add-spec! q s)
                  (catch Throwable t
                    (println (.toString t))))]
          (swap! responses conj r))))))
